import re


# In particolare, visto che il valore 111110 può comparire solo nei caratteri ASCII < e tilda, non è utile avere una sequenza per la rappresentazione di tale valore (infatti le differenti coppie di caratteri che compaiono sono al massimo 63, a cui si aggiungono le sequenze di controllo "zz" e "it")
# Simboli:    @     A     B     C     D     E     F     G     H     I     J     K     L     M     N     O     P     Q     R     S     T     U     V     W     X     Y     Z     [     \     ]     ^     _     `     a     b     c     d     e     f     g     h     i     j     k     l     m     n     o     p     q     r     s     t     u     v     w     x     y     z     {     |     }     ~     ?
chars =     ["op", "to", "fo", "de", "cn", "es", "dr", "cv", "dd", "gg", "ss", "uu", "ad", "nm", "mu", "ms", "bq", "qa", "dp", "da", "ma", "cc", "he", "re", "vx", "ee", "se", "rr", "cy", "un", "vt", "ar", "bo", "ft", "df", "vh", "th", "pp", "ra", "bu", "fa", "rf", "dr", "fg", "xv", "ho", "pe", "dq", "go", "gc", "cu", "si", "qq", "be", "ke", "cs", "vs", "rs", "sr", "ct", "gt", "kh", "..", "hp"]


def decodifica(source):
    res = ""
    
    for line in source.split("\n"):
        line = line.replace("\n", "")[2:]
        
        sbin = "".join([format(chars.index(c), "06b") for c in re.findall("[a-z]{2}", line) if not c == "ii"])
        sbin = sbin[:len(sbin)-(2*len(re.findall("ii", line)))]
        
        res += "".join([chr(int(a, 2)) for a in re.findall("[0,1]{8}", sbin)])  
        res += "\n"

    return res
        

def codifica(source):
    res = ""
    lines = list(filter(lambda s: len(s) > 2, source.split("\n")))
    
    for i in range(0, len(lines)):
        if i == 0:
            res += "zz"
        elif i == len(lines) - 1:
            res += "cc"
        else:
            res += "it"
        
        line = lines[i].replace("\n", "")
        
        sbin = "".join([format(ord(c), "08b") for c in line])
        fact = len(sbin)%3
        sbin += "00"*fact
        
        res += "".join([chars[int(a, 2)] for a in re.findall("[0,1]{6}", sbin)])
        res += "ii"*fact
        res += "\n"
    
    return res

if __name__ == '__main__':
    with open('IUC_2025_20251024.amn', 'r') as f:
        print(decodifica(f.read()))